/*jshint esversion: 6 */

define([
    "lib/dev/config",
	"src/utils", "lodash", "immutable",
	"lib/tasks/dofs", "lib/dev", "src/math/Mat3",
	"lib/tasks/internal"
	],
function(
    config,
	utils, lodash, immutable,
	dofs, dev, mat3,
	internal
) {

"use strict";

/*============================================================================
	Helpers
============================================================================*/

/*============================================================================
	API
============================================================================*/

var layer = config.MutableTree.enabled ? {

	// Get handle frames relative to Layer frame.
	// Returns array of objects with matrix and type.
	getHandleFrames (inLayer, mat_Layer0) {
		var layer = inLayer.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			mat_Puppet = internal.getPuppetFrame(tree);

		if (mat_Layer0) 
			mat3.multiply(mat_Layer0, mat_Puppet, mat_Puppet);

		var	path = internal.getKeyPath(layer, "value"),
			lomNow = path.layer.tomPrev.getIn(path.key);

		return internal.gatherHandleFrames(tree, lomNow, mat_Puppet);
	},

	// Set handle frames relative to Layer frame.
	// Expects array of objects with matrix and type.
	setHandleFrames (inLayer, aFrames) {
		var layer = inLayer.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			matLayer_Puppet = internal.getPuppetFrame(tree);

		var	path = internal.getKeyPath(layer, "value"),
			lomNow = path.layer.tomNow.getIn(path.key);

		internal.scatterHandleFrames(tree, aFrames, lomNow, matLayer_Puppet);
	}
} :
{   // OLD: to be removed

	// Get handle frames relative to Layer frame.
	// Returns array of objects with matrix and type.
	getHandleFrames (inLayer, mat_Layer0) {
		var layer = inLayer.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			mat_Puppet = internal.getPuppetFrame(tree);

		if (mat_Layer0) 
			mat3.multiply(mat_Layer0, mat_Puppet, mat_Puppet);

		var	path = internal.getKeyPath(layer, "value"),
			lomNow = path.layer.tomNow.getIn(path.key);

		return internal.gatherHandleFrames(tree, lomNow, mat_Puppet);
	},

	// Set handle frames relative to Layer frame.
	// Expects array of objects with matrix and type.
	setHandleFrames (inLayer, aFrames) {
		var layer = inLayer.getWarperLayer(),
			tree = layer.getHandleTreeArray(),
			matLayer_Puppet = internal.getPuppetFrame(tree);

		var	path = internal.getKeyPath(layer, "value"),
			lomNow = path.layer.tomNow.getIn(path.key);

		var lomNext = internal.scatterHandleFrames(tree, aFrames, lomNow, matLayer_Puppet);
		path.layer.tomNext = path.layer.tomNext.setIn(path.key, lomNext);
	}
};

return layer;

}); // end define


